# -*- coding: utf-8 -*-
"""
Created on Tue Nov  8 11:36:34 2022

@author: david
"""

from core_tools.data.ds.data_set import load_by_id, load_by_uuid
import numpy as np
import matplotlib.pyplot as plt

#Figures tricks
plt.rcParams['figure.dpi'] = 230 #Note: this is helpuful for high dpi displays such as 4k display on Windows
from core_tools.data.ds.ds_hdf5 import save_hdf5_uuid, load_hdf5_uuid

uuid = [16764_88268_797255110,
        16764_93201_636255110,
        16764_98331_236255110,
        16765_03047_674255110,
        16765_20092_493255110,
        16765_24879_650255110,
        16765_29918_304255110,
        16765_34602_060255110]

P0 = [[0.8266129032258072 , 1167.5430754752388],
      [0.7740182328190748 , 1176.1936947110762],
      [0.6250000000000007 , 1185.7889666854783],
      [0.4803646563814873 , 1194.540862036503],
      [0.5373422159887802 , 1225.9466403161823],
      [0.5943197755960739 , 1226.0525315264294],
      [0.8879733520336615 , 1227.6215396197836], #NO
      [0.5241935483870975 , 1241.7654394880353]]

P1 = [[ -1.356065918653576 , 1157.3557989836145],
      [-1.014200561009817 , 1167.8180124223504],
      [-1.0273492286115 , 1177.3897571993123 ],
      [-0.869565217391304 , 1187.129794842827 ],
      [-0.7161640953716685 , 1218.017974778821],
      [-0.7906732117812055 , 1218.006230001867],
      [-1.0404978962131832 , 1217.975388669285], #NO
      [-0.7599929873772787 , 1234.0014643327559]]

P2 = [[1.4577489481065924 , 1161.5671673254176],
      [1.0589060308555411 , 1170.6177489177392],
      [1.0194600280504915 , 1180.0718577074997 ],
      [0.800315568022441 , 1189.458987389411],
      [0.7389551192145867 , 1220.158949745883],
      [0.809081346423563 , 1220.4295313382117],
      [-1.224579242636746 , 1224.9394391115961], #NO
      [0.5154277699859755 , 1236.3071296818994 ]]

P3 = [[-1.2771739130434778 , 1164.3904310182463],
      [-1.316619915848527 , 1174.2409373235362],
      [-0.93969144460028 , 1183.2774854131276],
      [-0.9703716690042071 , 1192.7998494259252 ],
      [-0.9791374474053292 , 1224.5820628646484],
      [-1.0404978962131832 , 1224.7585356672162],
      [0.8134642356241244 , 1220.5633803877113], #NO
      [ -0.7906732117812055 , 1239.859736495376]]

peak = 7

uuid = np.array(uuid)

ds = load_hdf5_uuid(int(uuid[peak]),  r'W:\staff-groups\tnw\ns\qt\ScappucciLab\0_Group members\Davide\6nm_QW_paper\QuantumDots\3_Dev2\CoulombDiamonds')

# get x, y, and z data:
x = ds.m1.x()
y = ds.m1.y()
z = ds.m1() #or if you like you can also call m1.z()

fig, ax = plt.subplots()
ax.pcolormesh(y,x,z*1e9) #, vmin = -2, vmax = 2

aux = np.gradient(z,axis=1)
plt.figure()
plt.pcolormesh(y,x,aux)

def onclick(event):
    print('[',event.xdata/10,',', event.ydata,']')

number = plt.gcf().canvas.mpl_connect('button_press_event', onclick)

#%%

# aux = np.gradient(z,axis=1)
plt.figure()
plt.pcolormesh(y,x,z)

plt.scatter(P0[peak][0]*10,P0[peak][1], color = 'r')
plt.scatter(P1[peak][0]*10,P1[peak][1], color = 'r')
plt.scatter(P2[peak][0]*10,P2[peak][1], color = 'r')
plt.scatter(P3[peak][0]*10,P3[peak][1], color = 'r')

plt.plot([P0[peak][0]*10,P1[peak][0]*10], [P0[peak][1],P1[peak][1]], color = 'r')
plt.plot([P2[peak][0]*10,P3[peak][0]*10], [P2[peak][1],P3[peak][1]], color = 'r')
plt.ylabel('VP (mV)')
plt.xlabel('V$_{SD}$ (mV)')
# plt.colorbar()

aux = np.gradient(z,axis=1)
plt.figure()
plt.pcolormesh(y,x,aux)

plt.scatter(P0[peak][0]*10,P0[peak][1], color = 'r')
plt.scatter(P1[peak][0]*10,P1[peak][1], color = 'r')
plt.scatter(P2[peak][0]*10,P2[peak][1], color = 'r')
plt.scatter(P3[peak][0]*10,P3[peak][1], color = 'r')

plt.plot([P0[peak][0]*10,P1[peak][0]*10], [P0[peak][1],P1[peak][1]], color = 'r')
plt.plot([P2[peak][0]*10,P3[peak][0]*10], [P2[peak][1],P3[peak][1]], color = 'r')

plt.ylabel('VP (mV)')
plt.xlabel('V$_{SD}$ (mV)')
# plt.colorbar(label = 'dI/dV')

#Calculate lever arm
ms = (P0[peak][0]-P1[peak][0])/(P0[peak][1]-P1[peak][1])
md = (P2[peak][0]-P3[peak][0])/(P2[peak][1]-P3[peak][1])

a = abs(ms*md/(ms-md))
print(a)

#%% Lever arm peak 1758

V0 = np.array([1763.28])
V1 = np.array([1751.84])
V2 = np.array([1761.83])
V3 = np.array([1753.76])

Vsd0 = np.array([2.270])
Vsd1 = np.array([-2.666])
Vsd2 = np.array([-1.580])
Vsd3 = np.array([1.481])

ms = (Vsd0-Vsd1)/(V0-V1)
md = (Vsd2-Vsd3)/(V2-V3)

a = abs(ms*md/(ms-md))
print(a)

#%% Lever arm Uri data 6d2s

V0 = np.array([1247.5])
V1 = np.array([1235])
V2 = np.array([1242.5])
V3 = np.array([1240])

Vsd0 = np.array([1.4])
Vsd1 = np.array([-1.6])
Vsd2 = np.array([-1.2])
Vsd3 = np.array([1.4])

ms = (Vsd0-Vsd1)/(V0-V1)
md = (Vsd2-Vsd3)/(V2-V3)

a = abs(ms*md/(ms-md))















